package digital.paynetics;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;


class AesCrypto {
    private static final int IV_SIZE_BYTES = 16;

    public static byte[] encrypt(byte[] data, Key key) {
        try {
            byte[] iv = new byte[AesCrypto.IV_SIZE_BYTES];

            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);

            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            IvParameterSpec parameterSpec = new IvParameterSpec(iv);
            cipher.init(Cipher.ENCRYPT_MODE, key, parameterSpec);
            byte[] cipherData = cipher.doFinal(data);

            ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + cipherData.length);
            byteBuffer.put(iv);
            byteBuffer.put(cipherData);

            return byteBuffer.array();
        } catch (Exception e) {
            System.out.println(e.getMessage());
            // TODO: handle
            return null;
        }
    }

    public static byte[] decrypt(byte[] data, Key key) {
        try {
            byte[] iv = new byte[IV_SIZE_BYTES];
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            byteBuffer.get(iv);

            byte[] cipherData = new byte[byteBuffer.remaining()];
            byteBuffer.get(cipherData);

            byteBuffer.clear();

            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            IvParameterSpec parameterSpec = new IvParameterSpec(iv);
            cipher.init(Cipher.DECRYPT_MODE, key, parameterSpec);

            return cipher.doFinal(cipherData);
        } catch (Exception e) {
            System.out.println(e.getMessage());
            // TODO: handle
            return null;
        }
    }
}
