package main

import (
	"crypto/aes"
	"crypto/cipher"
	"crypto/rand"
	"encoding/base64"
	"encoding/hex"
	"fmt"
	"github.com/mergermarket/go-pkcs7"
	"io"
)

const CipherKey = "81f5829c74be8dc96f6b6b3c9bd2f8da829ee971306383d5c38aa8fb8ef9a90b"

func main() {

	encrypt, _ := Encrypt("test")
	fmt.Println(encrypt)
	fmt.Println(Decrypt( encrypt))

}

// Encrypt encrypts plain text string into cipher text string
func Encrypt(unencrypted string) (string, error) {

	key, _ := hex.DecodeString(CipherKey)

	plainText := []byte(unencrypted)

	plainText, err := pkcs7.Pad(plainText, aes.BlockSize)

	if err != nil {
		return "", fmt.Errorf(`plainText: "%s" has error`, plainText)
	}

	if len(plainText)%aes.BlockSize != 0 {
		err := fmt.Errorf(`plainText: "%s" has the wrong block size`, plainText)
		return "", err
	}

	block, err := aes.NewCipher(key)
	if err != nil {
		return "", err
	}

	cipherText := make([]byte, aes.BlockSize+len(plainText))
	iv := cipherText[:aes.BlockSize]
	if _, err := io.ReadFull(rand.Reader, iv); err != nil {
		return "", err
	}

	mode := cipher.NewCBCEncrypter(block, iv)
	mode.CryptBlocks(cipherText[aes.BlockSize:], plainText)

	return base64.StdEncoding.EncodeToString(cipherText), nil
}

// Decrypt decrypts cipher text string into plain text string
func Decrypt(encrypted string) (string, error) {
	key, _ := hex.DecodeString(CipherKey)

	cipherText, _ := base64.StdEncoding.DecodeString(encrypted)

	block, err := aes.NewCipher(key)

	if err != nil {
		panic(err)
	}

	if len(cipherText) < aes.BlockSize {
		panic("cipherText too short")
	}

	iv := cipherText[:aes.BlockSize]

	cipherText = cipherText[aes.BlockSize:]

	if len(cipherText)%aes.BlockSize != 0 {
		panic("cipherText is not a multiple of the block size")
	}

	mode := cipher.NewCBCDecrypter(block, iv)
	mode.CryptBlocks(cipherText, cipherText)

	cipherText, _ = pkcs7.Unpad(cipherText, aes.BlockSize)

	return fmt.Sprintf("%s", cipherText), nil
}
