<?php

function encrypt(string $content, string $key): string{

        //Generate iv
        $iv = openssl_random_pseudo_bytes(16);

        if(!$iv){
            throw new \RuntimeException('Unable to generate IV');
        }

        //Encrypt payload
        $cipher = openssl_encrypt(content, 'aes-256-cbc', base64_decode($key), OPENSSL_RAW_DATA, $iv);

        if(!$cipher){
            throw new \RuntimeException('Unable to encrypt');
        }

       return base64_encode($iv . $cipher);
}


function decrypt(string $cipher, string $key): string
{
    //Extract iv from payload
    $iv = substr($cipher, 0, 16);
    //Extract cipher text from payload
    $cipher = substr($cipher, 16);

    //Try to decrypt data may throw exception
    $plain = openssl_decrypt($cipher, 'aes-256-cbc', base64_decode($key), OPENSSL_RAW_DATA, $iv);

    if (!$plain) {
        throw new \RuntimeException('Unable to decrypt');
    }

    return $plain;
}
